clear
set more off
graph drop _all
use morg_cleaned_1976_emp.dta, clear
foreach yr of numlist 1977/2014 {
append using morg_cleaned_`yr'_emp.dta 
}

gen lfpr=(empstat==1 | empstat==2)*finwgt
gen emp=(empstat==1)*finwgt

sort year month state sex ageg ed 

collapse (sum) lfpr emp finwgt, by(year month state sex ageg ed)
replace lfpr=lfpr/finwgt
replace emp=emp/finwgt
rename finwgt n

sort year month state sex ageg ed
save collapse-state-emp-month.dta, replace

